#!/bin/bash

SRCDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

ARGC=$#
if [ $ARGC -lt 1 ]; then
  echo "Usage: $0 YourPluginName"
  echo "Create a proper plugin for the Shipping by Rules plugin from the provided template"
  exit -1;
fi

name=$1
pluginname=${name,,}
pLUGINNAME=${name,}
Pluginname=${name^}
PLUGINNAME=${name^^}

echo "Plugin name=$name, pluginname=$pluginname, pLUGINNAME=$pLUGINNAME, Pluginname=$Pluginname, PLUGINNAME=$PLUGINNAME"


mkdir -p $pluginname/language/en-GB/

sed "s/YOUR_PLUGIN_NAME/$Pluginname/g" $SRCDIR/YOUR_PLUGIN_NAME.php > $pluginname/$pluginname.php
sed "s/YOUR_PLUGIN_NAMEInstaller/${Pluginname}Installer/g; s/YOUR_PLUGIN_NAME/$pluginname/g" $SRCDIR/YOUR_PLUGIN_NAME.script.php > $pluginname/$pluginname.script.php
sed "s/YOUR_PLUGIN_NAME/$pluginname/g; s/VMSHIPMENTRULES_TEMPLATE/VMSHIPMENTRULES_$PLUGINNAME/g" $SRCDIR/YOUR_PLUGIN_NAME.xml > $pluginname/$pluginname.xml
sed "s/YOUR_PLUGIN_NAME/$pluginname/g" $SRCDIR/Makefile > $pluginname/Makefile
for i in $SRCDIR/language/en-GB/*.ini; do
  sed "s/YOUR_PLUGIN_NAME/$pluginname/g; s/VMSHIPMENTRULES_TEMPLATE/VMSHIPMENTRULES_$PLUGINNAME/g" $i > $pluginname/${i#$SRCDIR}
done
rename "s/YOUR_PLUGIN_NAME/$pluginname/g" $pluginname/language/en-GB/*
for i in `find $SRCDIR/ -name index.html`; do
  cp $i $pluginname/${i#$SRCDIR}
done

echo "Created new plugin '$pluginname' for the Shipping for Rules plugin. Please adjust the plugin's onVmShippingRulesGetCartValues, all copyright statements and the translations"