<?php

defined ('_JEXEC') or die('Restricted access');

/**
 * Plugin providing Custom variables for VM Shipping by Rules
 *
 * @subpackage Plugins - VmShipmentRules
 * @copyright Copyright (C) 2014 Reinhold Kainhofer, office@open-tools.net
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://open-tools.net/
 *
 */
if (!class_exists ('VmPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmplugin.php');
}

// An example callback function to provide a custom function for shipping rules:
function custom_test_function($args, $rule) {
	JFactory::getApplication()->enqueueMessage(JText::sprintf("Evaluating function custom_test_function in rule '%s'", htmlentities($rule->rulestring)), 'warning');
	return count($args);
}

/** Extension plugin for the "Shipping by Rules" shipping plugin for VirtueMart
 */
class plgVmShipmentRulesYOUR_PLUGIN_NAME extends VmPlugin {
	/**  Trigger to add variables to the cart values
	  *  You can add new variables to the $cartvals array or modify existing ones. They will be directly 
	  *  available in all rules.
	  *  This trigger will be first called right before any rule is evaluated. In that case, $products 
	  *  will contain all products in the cart and $cart_prices will be an arrow containing the calculated
	  *  prices of the order.
	  *  Please notice that this function might also be called for only a subset of products of the cart
	  *  when the plugin evaluates a scoping function like evaluate_for_categories(...).
	  *  In that case, $cart_prices will be NULL and the $products array will hold only those products that 
	  *  actually match the filter, and only those should be used to calculate your custom variables.
	  *  So you can not in general rely on the cart_prices argument to hold the properly summed prices.
	  */
	function onVmShippingRulesGetCartValues(&$cartvals, $cart, $products, $method, $cart_prices) {
		if ($cart_prices) {
			// Called for the whole cart...
		} else {
			// Called when any of the scoping operators need the cart values for only a subset of products
		}
		$cartvals['template_example'] = 123456789;
		
	}
	/** Trigger to register custom functions for the Shipping by Rules plugin 
	 *  The onVmShippingRulesRegisterCustomFunctions() trigger is expected to return an array of the form:
	 *   array ('functionname1' => 'function_to_be_called',
	 *          'functionname2' => array($classobject, 'memberfunc')),
	 *          'functionname3' => array('classname', 'staticmemberfunc')),
	 *          ...);
	 *  The callback functions referenced here are called with an array argument that holds 
	 *  all function arguments and the rule itself, so that error messages can display the offending rule.
	 *  I.e. the function signature should be
	 *     function function_to_be_called($args, $rule) {....}
	 *
	 *  All arguments passed to the function will already be properly evaluated before the function is called.
	 */
	function onVmShippingRulesRegisterCustomFunctions() {
		return array(
			// An example of a custom function that calls a member of this plugin class:
			'customTestFunctionMember' => array($this, 'custom_test_function_member'),
			// An example of a custom function that calls an ordinary top-level php function:
			'customTestFunction' => 'custom_test_function',
		);
	}
	
	function custom_test_function_member($args, $rule) {
		return 'CustomTestFunction called with '.count($args).' arguments.';
	}
}

// No closing tag
