<?php

defined ('_JEXEC') or die('Restricted access');

/**
 * AwoCoupon variables for VM Shipping by Rules
 *
 * @subpackage Plugins - VmShipmentRules
 * @copyright Copyright (C) 2014 Reinhold Kainhofer, office@open-tools.net
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://open-tools.net/
 *
 */
if (!class_exists ('VmPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmplugin.php');
}

/** Extension plugin for the "Shipping by Rules" shipping plugin for VirtueMart
 */
class plgVmShipmentRulesRules_AwoCoupon extends VmPlugin {
	/**  Trigger to add variables to the cart values
	  *  You can add new variables to the $cartvals array or modify existing ones. They will be directly 
	  *  available in all rules.
	  *  Please notice that this function might also be called for only a subset of products of the cart.
	  */
	function onVmShippingRulesGetCartValues(&$cartvals, $cart, $products, $method, $cart_prices) {
		$coupon_discount = 0;
		$session = JFactory::getSession();
		$coupon_row = $session->get('coupon', '', 'awocoupon');
		if(!empty($coupon_row)) {
			$coupon_row = unserialize($coupon_row);
 			$coupon_discount = $coupon_row['product_discount'] + $coupon_row['shipping_discount'];
		}
		$cartvals['awodiscount'] = $coupon_discount;
	}
}

// No closing tag
