<?php
defined('_JEXEC') or die();
/**
 *
 * @package    VirtueMart
 * @subpackage Plugins  - Fields
 * @author Reinhold Kainhofer, Open Tools
 * @link http://www.open-tools.net
 * @copyright Copyright (c) 2014 Reinhold Kainhofer. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.txt
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
 
defined('DS') or define('DS', DIRECTORY_SEPARATOR);
if (!class_exists( 'VmConfig' )) 
    require(JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php');
VmConfig::loadConfig();
if (!class_exists('OrdernumberHelperJoomla'))
	require_once (dirname(dirname(__FILE__)) . DS . 'ordernumber_helper_joomla.php');

class JFormFieldVmOrdernumberCounters extends JFormField {
    var $_name = 'vmOrdernumberCounters';

    protected $countertype;

    public function __get($name)
    {
        switch ($name) {
            case 'countertype':
                return $this->$name;
        }
        return parent::__get($name);
    }

    public function __set($name, $value)
    {
        switch ($name) {
            case 'countertype':
                $this->$name = (string) $value;
                break;
            default:
                parent::__set($name, $value);
        }
    }

    public function setup(SimpleXMLElement $element, $value, $group = null)
    {
        $return = parent::setup($element, $value, $group);

        if ($return) {
            $this->countertype  = (string) $this->element['countertype'];
        }

        return $return;
    }
    

	protected function makeJSTranslationsAvailable() {
		JText::script('PLG_ORDERNUMBER_JS_NOT_AUTHORIZED');
		JText::script('PLG_ORDERNUMBER_JS_NEWCOUNTER');
		JText::script('PLG_ORDERNUMBER_JS_EDITCOUNTER');
		JText::script('PLG_ORDERNUMBER_JS_INVALID_COUNTERVALUE');
		JText::script('PLG_ORDERNUMBER_JS_MODIFY_FAILED');
		JText::script('PLG_ORDERNUMBER_JS_DELETECOUNTER');
		JText::script('PLG_ORDERNUMBER_JS_DELETE_FAILED');
		JText::script('PLG_ORDERNUMBER_JS_ADD_FAILED');
		JText::script('PLG_ORDERNUMBER_JS_JSONERROR');
	}
	
	protected function getInput() {
		$helper = OrdernumberHelperJoomla::getHelper();

		$doc = JFactory::getDocument()->addStyleSheet($helper->urlPath('css', 'ordernumber.css'));
// 		$this->makeJSTranslationsAvailable();
		$helper->loadjQuery();
		$doc->addScript($helper->urlPath('js', 'ordernumber.js'));
        
		$counters = $helper->getAllCounters($this->countertype);
		return $helper->counter_modification_create_table ($this->countertype, $counters);
	}
}
