(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36424,       1198]
NotebookOptionsPosition[     30494,        993]
NotebookOutlinePosition[     31058,       1013]
CellTagsIndexPosition[     31015,       1010]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Decoding the parameters of the magicolor 1690MF scanner protocol\
\>", "Title",
 CellChangeTimes->{{3.492771629004439*^9, 3.492771641499832*^9}, 
   3.492791982816052*^9}],

Cell[CellGroupData[{

Cell["Image area", "Section",
 CellChangeTimes->{{3.49277164573181*^9, 3.492771647791243*^9}, 
   3.492791982816257*^9}],

Cell["\<\
A4 sends 0x1390 \[Cross] 0x1b94 (i.e. 7008\[Cross]7060) pixel, A6 sends \
0x09e0 \[Cross] 0dd8 (i.e. 2528\[Cross]3544) pixel, whole FBF area is 0x13f8\
\[Cross]20dc (i.e. 5112\[Cross]8412) pixel.\
\>", "Text",
 CellChangeTimes->{{3.492771651467335*^9, 3.492771724698414*^9}, 
   3.492791982816423*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FBFpxSent", "=", 
   RowBox[{"{", 
    RowBox[{"5112", ",", " ", "8412"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A4pxSent", "=", 
   RowBox[{"{", 
    RowBox[{"5008", ",", "7060"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A6pxSent", "=", 
   RowBox[{"{", 
    RowBox[{"2528", ",", "3544"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.492771782179721*^9, 3.492771794590359*^9}, {
   3.492771861118372*^9, 3.49277190794313*^9}, {3.492771984274481*^9, 
   3.492772017522966*^9}, 3.492791982817646*^9}],

Cell["\<\
They are not multiples of any large byte count, not even multiples of 8:\
\>", "Text",
 CellChangeTimes->{{3.492772101704943*^9, 3.492772136135655*^9}, 
   3.492791982828858*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "@@", 
  RowBox[{"Join", "[", 
   RowBox[{"FBFpxSent", ",", " ", "A4pxSent", ",", " ", "A6pxSent"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.492772054032501*^9, 3.49277212707399*^9}, 
   3.492791982830913*^9}],

Cell[BoxData["4"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492772095801629*^9, 3.492772127624403*^9}, 
   3.492791982835332*^9}]
}, Open  ]],

Cell["In 600 dpi, A4 and A6 would have the following pixel extent:", "Text",
 CellChangeTimes->{{3.492771914128486*^9, 3.492771927352897*^9}, 
   3.492791982839195*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"A4px", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"21", ",", "29.7"}], "}"}], "*", 
   FractionBox["600", "2.54"]}]}], "\[IndentingNewLine]", 
 RowBox[{"A6px", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10.5", ",", "14.85"}], "}"}], "*", 
   FractionBox["600", "2.54"]}]}]}], "Input",
 CellChangeTimes->{{3.492771576942347*^9, 3.492771602542774*^9}, {
   3.492771941606975*^9, 3.49277195522737*^9}, {3.492771996608011*^9, 
   3.492772015037617*^9}, 3.492791982839884*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4960.629921259842`", ",", "7015.748031496062`"}], "}"}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492771955648953*^9, {3.492772003247813*^9, 3.492772027883504*^9}, 
   3.492791982843384*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2480.314960629921`", ",", "3507.874015748031`"}], "}"}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492771955648953*^9, {3.492772003247813*^9, 3.492772027890265*^9}, 
   3.492791982847954*^9}]
}, Open  ]],

Cell["The difference (i.e. additional pixels added) is:", "Text",
 CellChangeTimes->{{3.492771959154275*^9, 3.492771971438046*^9}, 
   3.492791982851559*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"A4pxSent", "-", "A4px"}], "\[IndentingNewLine]", 
 RowBox[{"A6pxSent", "-", "A6px"}]}], "Input",
 CellChangeTimes->{{3.492771972931011*^9, 3.492772022979217*^9}, 
   3.492791982852303*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"47.37007874015762`", ",", "44.25196850393786`"}], "}"}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492772024349195*^9, 3.492772028799516*^9}, 
   3.492791982856535*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"47.68503937007881`", ",", "36.12598425196893`"}], "}"}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492772024349195*^9, 3.492772028806276*^9}, 
   3.49279198286086*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Brightness values", "Section",
 CellChangeTimes->{{3.492773123512007*^9, 3.4927731254713*^9}, 
   3.492791982864195*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"1", ",", "9"}], "]"}], ",", " ", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.492773130530991*^9, 3.492773140992185*^9}, 
   3.492791982864987*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     SubscriptBox["\<\"1\"\>", "\<\"2\"\>"],
     1,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"10\"\>", "\<\"2\"\>"],
     2,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"11\"\>", "\<\"2\"\>"],
     3,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"100\"\>", "\<\"2\"\>"],
     4,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"101\"\>", "\<\"2\"\>"],
     5,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"110\"\>", "\<\"2\"\>"],
     6,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"111\"\>", "\<\"2\"\>"],
     7,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"1000\"\>", "\<\"2\"\>"],
     8,
     Editable->False], ",", 
    InterpretationBox[
     SubscriptBox["\<\"1001\"\>", "\<\"2\"\>"],
     9,
     Editable->False]}], "}"}],
  BaseForm[#, 2]& ]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492773132496251*^9, 3.492773141456382*^9}, 
   3.492791982869286*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parameter of the 0x03 08 command (start scan)", "Section",
 CellChangeTimes->{{3.492790211810813*^9, 3.492790227518601*^9}, 
   3.492791982873903*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "depth", ",", "colors", ",", "xext", ",", "yext", ",", "pxPerLine", ",", 
    " ", "lines", ",", " ", "param"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.492791816432168*^9, 3.492791831438146*^9}, 
   3.492791982874804*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"depth", "[", "BW", "]"}], "=", "8"}], ";", 
  RowBox[{
   RowBox[{"depth", "[", "Gr", "]"}], "=", "24"}], ";", 
  RowBox[{
   RowBox[{"depth", "[", "Co", "]"}], "=", "24"}], ";"}]], "Input",
 CellChangeTimes->{{3.492790775361864*^9, 3.492790826518943*^9}, {
   3.492791280756443*^9, 3.492791285105692*^9}, 3.492791982879371*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"colors", "[", "BW", "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"colors", "[", "Gr", "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"colors", "[", "Co", "]"}], "=", "3"}], ";"}]], "Input",
 CellChangeTimes->{{3.492790775361864*^9, 3.492790826518943*^9}, 
   3.492791982883596*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xext", "=", "16^^13f8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yext", "=", "16^^20dc"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pxPerLine", "=", "16^^0837"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "=", "16^^04fe"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, 
   3.492790834199676*^9, {3.492791951513334*^9, 3.492791982888003*^9}}],

Cell[BoxData["2103"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492791833706073*^9, {3.492791971139308*^9, 3.492791982894148*^9}}],

Cell[BoxData["1278"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492791833706073*^9, {3.492791971147577*^9, 3.492791982899742*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "[", "BW", "]"}], "=", 
  "16^^00106e00"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param", "[", "Gr", "]"}], "=", 
  "16^^00314a00"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param", "[", "Co", "]"}], "=", "16^^0093de00"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, {
   3.492790834199676*^9, 3.492790844775785*^9}, 3.492791982904438*^9}],

Cell[BoxData["1076736"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492791834384733*^9, {3.492791971959502*^9, 3.492791982909401*^9}}],

Cell[BoxData["3230208"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492791834384733*^9, {3.492791971964837*^9, 3.492791982914473*^9}}],

Cell[BoxData["9690624"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492791834384733*^9, {3.492791971969203*^9, 3.492791982918797*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vls", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492790867437985*^9, 3.492790932818649*^9}, {
  3.492791862167506*^9, 3.492791862512351*^9}, {3.49279197943109*^9, 
  3.492791989668206*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16824", ",", "50472", ",", "151416"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492790888474639*^9, 3.492790937127367*^9}, 
   3.492791287882083*^9, 3.492791460246506*^9, {3.492791846970276*^9, 
   3.492791865096787*^9}, {3.492791972890798*^9, 3.492791990609779*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"param", "[", "#", "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492790922020972*^9, 3.49279093537839*^9}, 
   3.49279198292795*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1076736", ",", "3230208", ",", "9690624"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.49279184824886*^9, 3.492791866144099*^9}, {
  3.492791974477409*^9, 3.492791992753131*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "/", "vls"}]], "Input",
 CellChangeTimes->{{3.492790939107715*^9, 3.492790940457938*^9}, {
   3.492790993457185*^9, 3.492790993786049*^9}, 3.492791298829808*^9, 
   3.492791982936682*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"64", ",", "64", ",", "64"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791855449078*^9, 3.492791867213976*^9}, {
  3.492791976762234*^9, 3.492791995229356*^9}}]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.492791444672806*^9, 3.492791982945108*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xext", "=", "16^^1ec"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yext", "=", "16^^1ec"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pxPerLine", "=", "16^^007b"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "=", "16^^007b"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, 
   3.492790834199676*^9, {3.492791389082559*^9, 3.492791428689177*^9}, 
   3.49279198294597*^9}],

Cell[BoxData["123"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492790835198983*^9, 3.492791286925119*^9, 
  3.492791429393308*^9, 3.492791982950374*^9}],

Cell[BoxData["123"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492790835198983*^9, 3.492791286925119*^9, 
  3.492791429399607*^9, 3.492791982954939*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "[", "BW", "]"}], "=", 
  "16^^0000f600"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param", "[", "Gr", "]"}], "=", 
  "16^^0000f600"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param", "[", "Co", "]"}], "=", "16^^0000f600"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, {
   3.492790834199676*^9, 3.492790844775785*^9}, {3.492791450184045*^9, 
   3.492791458172573*^9}, 3.49279198295952*^9}],

Cell[BoxData["62976"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492790306808345*^9, 3.492790368929146*^9, {3.49279084689582*^9, 
   3.492790854989343*^9}, 3.492791287443322*^9, {3.492791431356429*^9, 
   3.492791458948748*^9}, 3.49279198296389*^9}],

Cell[BoxData["62976"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492790306808345*^9, 3.492790368929146*^9, {3.49279084689582*^9, 
   3.492790854989343*^9}, 3.492791287443322*^9, {3.492791431356429*^9, 
   3.492791458955732*^9}, 3.492791982968818*^9}],

Cell[BoxData["62976"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492790306808345*^9, 3.492790368929146*^9, {3.49279084689582*^9, 
   3.492790854989343*^9}, 3.492791287443322*^9, {3.492791431356429*^9, 
   3.492791459081045*^9}, 3.492791982973057*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vls", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492790867437985*^9, 3.492790932818649*^9}, 
   3.492791982977374*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"984", ",", "2952", ",", "8856"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492790888474639*^9, 3.492790937127367*^9}, 
   3.492791287882083*^9, 3.492791460246506*^9, 3.492791982981605*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"param", "[", "#", "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492790922020972*^9, 3.49279093537839*^9}, 
   3.492791982985892*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"62976", ",", "62976", ",", "62976"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492790927787184*^9, 3.492790937784211*^9}, 
   3.492791295022118*^9, 3.492791461624542*^9, 3.492791982990304*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "/", "vls"}]], "Input",
 CellChangeTimes->{{3.492790939107715*^9, 3.492790940457938*^9}, {
   3.492790993457185*^9, 3.492790993786049*^9}, 3.492791298829808*^9, 
   3.492791982993994*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"64", ",", 
   FractionBox["64", "3"], ",", 
   FractionBox["64", "9"]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791466136556*^9, 3.492791982998442*^9}]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.492791465050625*^9, 3.49279198300215*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["22432", "213."]], "Input",
 CellChangeTimes->{3.492791490178793*^9, 3.49279198300228*^9}],

Cell[BoxData["105.31455399061034`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.492790940872576*^9, 3.492790994049276*^9, {3.492791295965829*^9, 
   3.492791299146863*^9}, 3.492791490483423*^9, 3.492791983006497*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"param", "/", "lines"}]], "Input",
 CellChangeTimes->{{3.492790314118824*^9, 3.492790315504447*^9}, 
   3.492791983010186*^9}],

Cell[BoxData["512"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492790315891895*^9, 3.492791983014046*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"16^^1ec", "*", "2"}], ",", " ", "16"}], "]"}]], "Input",
 CellChangeTimes->{{3.492790407605412*^9, 3.492790417757406*^9}, 
   3.492791983017105*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"3d8\"\>", "\<\"16\"\>"],
   984,
   Editable->False],
  BaseForm[#, 16]& ]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492790410120235*^9, 3.492790418069955*^9}, 
   3.492791983020848*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"0", "x0100", "*", "2", "*", "\[IndentingNewLine]", 
  RowBox[{"(", 
   RowBox[{"x", "-", 
    RowBox[{"Extent", "*", 
     FractionBox["res", 
      RowBox[{"600", "dpi"}]]}]}], ")"}], "*", "depth", " ", "in", " ", 
  "byte", "*", "colors"}]], "Input",
 CellChangeTimes->{{3.492790534215145*^9, 3.492790535338187*^9}, {
   3.492790620841827*^9, 3.492790708652486*^9}, {3.492790748381304*^9, 
   3.492790772530737*^9}, 3.492791983025625*^9}],

Cell[BoxData[
 RowBox[{"xext", "*"}]], "Input",
 CellChangeTimes->{{3.492790538935688*^9, 3.492790542373624*^9}, 
   3.492791983025828*^9}],

Cell[CellGroupData[{

Cell["Default flatbed", "Subsection",
 CellChangeTimes->{{3.492791609471262*^9, 3.492791614862813*^9}, 
   3.492791983025974*^9, {3.492792547764015*^9, 3.492792550512754*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xext", "=", "16^^140"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yext", "=", "16^^1ec"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pxPerLine", "=", "16^^7b"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "=", "16^^50"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, 
   3.492790834199676*^9, {3.492791644326888*^9, 3.492791674866034*^9}, 
   3.492791983027368*^9, {3.492792436961692*^9, 3.492792470745852*^9}}],

Cell[BoxData["80"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791675999123*^9, 3.492791983031637*^9, 
  3.492792471353919*^9}],

Cell[BoxData["123"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791675999123*^9, 3.492791983031637*^9, 
  3.492792471347348*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"param", "=", "16^^f600"}]], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, {
   3.492790834199676*^9, 3.492790844775785*^9}, {3.49279167921631*^9, 
   3.492791698526813*^9}, 3.492791983040044*^9, {3.492792479856381*^9, 
   3.492792480606146*^9}}],

Cell[BoxData["62976"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791698884931*^9, 3.492791983044241*^9, 
  3.49279248108265*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vl", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"64", "*", "pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", "BW", "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492791718980996*^9, 3.492791746320857*^9}, 
   3.492791983048676*^9, {3.492792495657771*^9, 3.492792510821215*^9}}],

Cell[BoxData[
 RowBox[{"{", "62976", "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791719957428*^9, 3.492791746678238*^9}, 
   3.492791983052953*^9, {3.492792486893903*^9, 3.492792511413191*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Default flatbed, x- and y-extent larger", "Subsection",
 CellChangeTimes->{{3.492791609471262*^9, 3.492791614862813*^9}, 
   3.492791983025974*^9, {3.492792547764015*^9, 3.492792562345317*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xext", "=", "16^^1ec"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yext", "=", "16^^5b0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pxPerLine", "=", "16^^16c"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "=", "16^^7b"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, 
   3.492790834199676*^9, {3.492791644326888*^9, 3.492791674866034*^9}, 
   3.492791983027368*^9, {3.492792436961692*^9, 3.492792470745852*^9}, {
   3.492792568628384*^9, 3.492792589187594*^9}}],

Cell[BoxData["123"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791675999123*^9, 3.492791983031637*^9, 
  3.492792471353919*^9, 3.492792590021146*^9}],

Cell[BoxData["364"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791675999123*^9, 3.492791983031637*^9, 
  3.492792471353919*^9, 3.49279259001262*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"param", "=", "16^^0002d800"}]], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, {
   3.492790834199676*^9, 3.492790844775785*^9}, {3.49279167921631*^9, 
   3.492791698526813*^9}, 3.492791983040044*^9, {3.492792479856381*^9, 
   3.492792480606146*^9}, {3.492792596625405*^9, 3.492792598967567*^9}}],

Cell[BoxData["186368"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791698884931*^9, 3.492791983044241*^9, 
  3.49279248108265*^9, 3.492792599661817*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vl", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"64", "*", "pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", "BW", "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492791718980996*^9, 3.492791746320857*^9}, 
   3.492791983048676*^9, {3.492792495657771*^9, 3.492792510821215*^9}}],

Cell[BoxData[
 RowBox[{"{", "186368", "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791719957428*^9, 3.492791746678238*^9}, 
   3.492791983052953*^9, {3.492792486893903*^9, 3.492792511413191*^9}, 
   3.492792602347375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Default ADF A6 (BW)", "Subsection",
 CellChangeTimes->{{3.492791609471262*^9, 3.492791614862813*^9}, 
   3.492791983025974*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xext", "=", "16^^09e0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yext", "=", "16^^0dd8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pxPerLine", "=", "16^^0376"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "=", "16^^0278"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, 
   3.492790834199676*^9, {3.492791644326888*^9, 3.492791674866034*^9}, 
   3.492791983027368*^9, {3.492793163786777*^9, 3.492793167454416*^9}}],

Cell[BoxData["632"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791675999123*^9, 3.492791983031637*^9, 
  3.492793114707326*^9, 3.492793168491897*^9}],

Cell[BoxData["886"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791675999123*^9, 3.492791983031637*^9, 
  3.492793114707326*^9, 3.492793168482434*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"param", "=", "16^^0006ec00"}]], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, {
   3.492790834199676*^9, 3.492790844775785*^9}, {3.49279167921631*^9, 
   3.492791698526813*^9}, 3.492791983040044*^9}],

Cell[BoxData["453632"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791698884931*^9, 3.492791983044241*^9, 
  3.492793117395136*^9, 3.492793170236532*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vl", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"64", "*", "pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", "BW", "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492791718980996*^9, 3.492791746320857*^9}, 
   3.492791983048676*^9, {3.492793113271428*^9, 3.492793129413072*^9}}],

Cell[BoxData[
 RowBox[{"{", "453632", "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791719957428*^9, 3.492791746678238*^9}, 
   3.492791983052953*^9, 3.492793130447479*^9, 3.492793171731529*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"param", "/", "vl"}]], "Input",
 CellChangeTimes->{{3.49279173111659*^9, 3.492791732191332*^9}, 
   3.492791983057258*^9}],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791732491365*^9, 3.492791748266986*^9}, 
   3.492791983061499*^9, 3.492793132788112*^9, 3.492793174005414*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BW/Gray/Color 150dpi, l/r/t/b as above", "Subsection",
 CellChangeTimes->{{3.492791609471262*^9, 3.492791614862813*^9}, 
   3.492791983025974*^9, {3.492793425320144*^9, 3.492793455598245*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "param", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.492793526678708*^9, 3.492793529638439*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xext", "=", "16^^0324"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yext", "=", "16^^0298"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pxPerLine", "=", "16^^00a6"}], "\[IndentingNewLine]", 
 RowBox[{"lines", "=", "16^^00c9"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, 
   3.492790834199676*^9, {3.492791644326888*^9, 3.492791674866034*^9}, 
   3.492791983027368*^9, {3.492793163786777*^9, 3.492793167454416*^9}, {
   3.49279346315237*^9, 3.492793479025354*^9}}],

Cell[BoxData["166"], "Output",
 CellChangeTimes->{3.492793530706541*^9, 3.492793844083055*^9}],

Cell[BoxData["201"], "Output",
 CellChangeTimes->{3.492793530706541*^9, 3.492793844090507*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "[", "BW", "]"}], "=", 
  "16^^00014c00"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param", "[", "Gr", "]"}], "=", 
  "16^^00029800"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param", "[", "Co", "]"}], "=", "16^^0003e400"}]}], "Input",
 CellChangeTimes->{{3.492790230423517*^9, 3.492790366981807*^9}, {
   3.492790834199676*^9, 3.492790844775785*^9}, {3.49279167921631*^9, 
   3.492791698526813*^9}, 3.492791983040044*^9, {3.492793484228077*^9, 
   3.492793538983467*^9}}],

Cell[BoxData["254976"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791698884931*^9, 3.492791983044241*^9, 
  3.492793117395136*^9, 3.492793170236532*^9, 3.492793540051353*^9, 
  3.492793844830682*^9}],

Cell[BoxData["169984"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791698884931*^9, 3.492791983044241*^9, 
  3.492793117395136*^9, 3.492793170236532*^9, 3.492793540051353*^9, 
  3.492793844821857*^9}],

Cell[BoxData["84992"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.492791698884931*^9, 3.492791983044241*^9, 
  3.492793117395136*^9, 3.492793170236532*^9, 3.492793540051353*^9, 
  3.492793844813155*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"depth", "[", "#", "]"}], "*", 
    RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "16", ",", 
   FractionBox["72", "3"]}], "}"}]], "Input",
 CellChangeTimes->{{3.492793930387376*^9, 3.492793938361178*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "16", ",", "24"}], "}"}]], "Output",
 CellChangeTimes->{3.492793938993394*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vl", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"64", "*", "pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492791718980996*^9, 3.492791746320857*^9}, 
   3.492791983048676*^9, {3.492793113271428*^9, 3.492793129413072*^9}, {
   3.492793545089574*^9, 3.492793546448539*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"84992", ",", "254976", ",", "764928"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791719957428*^9, 3.492791746678238*^9}, 
   3.492791983052953*^9, 3.492793130447479*^9, 3.492793171731529*^9, 
   3.492793547398425*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"vl", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"64", "*", "pxPerLine", "*", 
     RowBox[{"depth", "[", "#", "]"}], "*", 
     RowBox[{"colors", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.492791718980996*^9, 3.492791746320857*^9}, 
   3.492791983048676*^9, {3.492793113271428*^9, 3.492793129413072*^9}, {
   3.492793545089574*^9, 3.492793546448539*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"param", "/@", 
    RowBox[{"{", 
     RowBox[{"BW", ",", "Gr", ",", "Co"}], "}"}]}], ")"}], "/", 
  "vl"}]], "Input",
 CellChangeTimes->{{3.49279173111659*^9, 3.492791732191332*^9}, 
   3.492791983057258*^9, {3.49279358628489*^9, 3.492793609711983*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["2", "3"], ",", 
   FractionBox["1", "3"]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492791732491365*^9, 3.492791748266986*^9}, 
   3.492791983061499*^9, 3.492793132788112*^9, 3.492793174005414*^9, {
   3.492793589707051*^9, 3.492793610853867*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Temp", "Section",
 CellChangeTimes->{{3.492772144055256*^9, 3.492772144419217*^9}, 
   3.492791983065191*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"16^^4008", " ", "*", " ", "3"}], "+", "16^^3008", "+", 
    "16^^e08"}], ",", " ", "16"}], "]"}]], "Input",
 CellChangeTimes->{{3.49278080286801*^9, 3.492780842101688*^9}, 
   3.492791983065974*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"fe28\"\>", "\<\"16\"\>"],
   65064,
   Editable->False],
  BaseForm[#, 16]& ]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.492780823656323*^9, 3.492780842429005*^9}, 
   3.492791983069941*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{640, 750},
WindowMargins->{{Automatic, -167}, {0, Automatic}},
ShowSelection->True,
FrontEndVersion->"7.0 for Linux x86 (32-bit) (February 25, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]]}, Visible -> False, 
  FrontEndVersion -> "7.0 for Linux x86 (32-bit) (February 25, 2009)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 181, 4, 197, "Title"],
Cell[CellGroupData[{
Cell[773, 30, 120, 2, 73, "Section"],
Cell[896, 34, 311, 6, 51, "Text"],
Cell[1210, 42, 584, 15, 77, "Input"],
Cell[1797, 59, 188, 4, 31, "Text"],
Cell[CellGroupData[{
Cell[2010, 67, 244, 6, 32, "Input"],
Cell[2257, 75, 170, 4, 31, "Output"]
}, Open  ]],
Cell[2442, 82, 168, 2, 31, "Text"],
Cell[CellGroupData[{
Cell[2635, 88, 503, 13, 83, "Input"],
Cell[3141, 103, 276, 8, 31, "Output"],
Cell[3420, 113, 276, 8, 31, "Output"]
}, Open  ]],
Cell[3711, 124, 157, 2, 31, "Text"],
Cell[CellGroupData[{
Cell[3893, 130, 213, 4, 55, "Input"],
Cell[4109, 136, 251, 7, 31, "Output"],
Cell[4363, 145, 250, 7, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4662, 158, 126, 2, 73, "Section"],
Cell[CellGroupData[{
Cell[4813, 164, 239, 6, 32, "Input"],
Cell[5055, 172, 1188, 44, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6292, 222, 156, 2, 101, "Section"],
Cell[6451, 226, 295, 7, 32, "Input"],
Cell[6749, 235, 375, 9, 32, "Input"],
Cell[7127, 246, 330, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[7482, 259, 421, 8, 99, "Input"],
Cell[7906, 269, 172, 4, 31, "Output"],
Cell[8081, 275, 172, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8290, 284, 427, 10, 77, "Input"],
Cell[8720, 296, 175, 4, 31, "Output"],
Cell[8898, 302, 175, 4, 31, "Output"],
Cell[9076, 308, 175, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9288, 317, 433, 11, 32, "Input"],
Cell[9724, 330, 356, 7, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10117, 342, 279, 8, 32, "Input"],
Cell[10399, 352, 265, 6, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10701, 363, 216, 4, 32, "Input"],
Cell[10920, 369, 251, 6, 31, "Output"]
}, Open  ]],
Cell[11186, 378, 91, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[11302, 383, 444, 9, 99, "Input"],
Cell[11749, 394, 191, 4, 31, "Output"],
Cell[11943, 400, 191, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12171, 409, 476, 11, 77, "Input"],
Cell[12650, 422, 291, 6, 31, "Output"],
Cell[12944, 430, 292, 6, 31, "Output"],
Cell[13239, 438, 292, 6, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13568, 449, 362, 10, 32, "Input"],
Cell[13933, 461, 277, 6, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14247, 472, 280, 8, 32, "Input"],
Cell[14530, 482, 281, 6, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14848, 493, 216, 4, 32, "Input"],
Cell[15067, 499, 244, 7, 47, "Output"]
}, Open  ]],
Cell[15326, 509, 90, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[15441, 514, 117, 2, 47, "Input"],
Cell[15561, 518, 257, 5, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15855, 528, 149, 3, 32, "Input"],
Cell[16007, 533, 144, 3, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16188, 541, 212, 5, 32, "Input"],
Cell[16403, 548, 293, 10, 31, "Output"]
}, Open  ]],
Cell[16711, 561, 464, 10, 70, "Input"],
Cell[17178, 573, 139, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[17342, 580, 175, 2, 39, "Subsection"],
Cell[CellGroupData[{
Cell[17542, 586, 487, 9, 99, "Input"],
Cell[18032, 597, 168, 4, 31, "Output"],
Cell[18203, 603, 169, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18409, 612, 297, 5, 32, "Input"],
Cell[18709, 619, 170, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18916, 628, 381, 9, 32, "Input"],
Cell[19300, 639, 242, 5, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19591, 650, 199, 2, 39, "Subsection"],
Cell[CellGroupData[{
Cell[19815, 656, 538, 10, 99, "Input"],
Cell[20356, 668, 191, 4, 31, "Output"],
Cell[20550, 674, 190, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20777, 683, 347, 5, 32, "Input"],
Cell[21127, 690, 193, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21357, 699, 381, 9, 32, "Input"],
Cell[21741, 710, 269, 6, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22059, 722, 133, 2, 39, "Subsection"],
Cell[CellGroupData[{
Cell[22217, 728, 493, 9, 99, "Input"],
Cell[22713, 739, 191, 4, 31, "Output"],
Cell[22907, 745, 191, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23135, 754, 251, 4, 32, "Input"],
Cell[23389, 760, 194, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23620, 769, 381, 9, 32, "Input"],
Cell[24004, 780, 241, 5, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24282, 790, 145, 3, 32, "Input"],
Cell[24430, 795, 236, 5, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24715, 806, 198, 2, 39, "Subsection"],
Cell[24916, 810, 149, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[25090, 817, 542, 10, 99, "Input"],
Cell[25635, 829, 94, 1, 31, "Output"],
Cell[25732, 832, 94, 1, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25863, 838, 526, 12, 77, "Input"],
Cell[26392, 852, 241, 5, 31, "Output"],
Cell[26636, 859, 241, 5, 31, "Output"],
Cell[26880, 866, 240, 5, 31, "Output"]
}, Open  ]],
Cell[27135, 874, 221, 7, 32, "Input"],
Cell[CellGroupData[{
Cell[27381, 885, 172, 4, 47, InheritFromParent],
Cell[27556, 891, 127, 3, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27720, 899, 468, 11, 32, "Input"],
Cell[28191, 912, 309, 7, 31, "Output"]
}, Open  ]],
Cell[28515, 922, 468, 11, 32, "Input"],
Cell[CellGroupData[{
Cell[29008, 937, 305, 8, 32, "Input"],
Cell[29316, 947, 363, 9, 47, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29740, 963, 115, 2, 73, "Section"],
Cell[CellGroupData[{
Cell[29880, 969, 275, 7, 32, "Input"],
Cell[30158, 978, 296, 10, 31, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
