################################################################################m#
#  Skript to generate US Basic (select and ultimate) valuation table objects  ####
################################################################################m#
library(MortalityTables)
library(here)
library(readxl)
library(dplyr)
# library(purrr)

US.annuities.file = here::here("data-raw", "US", "Annuities", "USA_Annuities.xlsx")



##############################################################################h#
### 1937 Standard Annuity Table                                             ####
##############################################################################h#

USA1937Annuity.data = read_excel(
  US.annuities.file, sheet = "1937 Standard",
  col_names = c("age","qx"),
  skip = 7)

USA1937Annuity = mortalityTable.period(
  name = "USA 1937 Standard Annuity Table, male",
  ages = USA1937Annuity.data$age,
  deathProbs = USA1937Annuity.data$qx,
  data = list(
    dim = list(table = "1937 Standard Annuity", sex = "m", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1937)
  )
)

save(USA1937Annuity,
     file = here::here("data", "USA1937Annuity.RData")
)



##############################################################################h#
### a-1949 Annuity Table                                                    ####
##############################################################################h#

USAa1949.data = read_excel(
  US.annuities.file, sheet = "a-1949",
  col_names = c("age","qx", "qy"),
  skip = 6)

USAa1949 = array(
  data = c(
    mortalityTable.period(
      name = "USA a-1949 male",
      ages = USAa1949.data$age,
      baseYear = 1949,
      deathProbs = USAa1949.data$qx,
      data = list(
        dim = list(table = "a-1949", sex = "m", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1949, country = "USA")
      )
    ),
    mortalityTable.period(
      name = "USA a-1949 female",
      ages = USAa1949.data$age,
      baseYear = 1949,
      deathProbs = USAa1949.data$qy,
      data = list(
        dim = list(table = "a-1949", sex = "f", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1949, country = "USA")
      )
    )
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

save(USAa1949,
     file = here::here("data", "USAa1949.RData")
)



##############################################################################h#
### 1971 IAM individual annuity table; with optional projection scale B_x   ####
##############################################################################h#

USA1971IAM.data = read_excel(
  US.annuities.file, sheet = "1971 IAM",
  col_names = c("age","qx", "qy", "B"),
  skip = 4)

USA1971IAM.male = mortalityTable.period(
  name = "USA 1971 IAM, male",
  ages = USA1971IAM.data$age,
  deathProbs = USA1971IAM.data$qx,
  data = list(
    dim = list(table = "1971 IAM", sex = "m", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM.female = mortalityTable.period(
  name = "USA 1971 IAM, female",
  ages = USA1971IAM.data$age,
  deathProbs = USA1971IAM.data$qy,
  data = list(
    dim = list(table = "1971 IAM", sex = "f", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM.male.projected = mortalityTable.improvementFactors(
  name = "USA 1971 IAM, male, projected",
  ages = USA1971IAM.data$age,
  baseYear = 1971,
  deathProbs = USA1971IAM.data$qx,
  improvement = USA1971IAM.data$B,
  data = list(
    dim = list(table = "1971 IAM projected", sex = "m", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM.female.projected = mortalityTable.improvementFactors(
  name = "USA 1971 IAM, female, projected",
  ages = USA1971IAM.data$age,
  baseYear = 1971,
  deathProbs = USA1971IAM.data$qy,
  improvement = USA1971IAM.data$B,
  data = list(
    dim = list(table = "1971 IAM projected", sex = "f", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM = array(
  data = c(
    USA1971IAM.male, USA1971IAM.female, USA1971IAM.male.projected, USA1971IAM.female.projected
  ),
  dim = c(2, 2),
  dimnames = list(Sex = c("m", "f"), type = c("Period", "Generational"))
)

save(USA1971IAM, USA1971IAM.male, USA1971IAM.female, USA1971IAM.male.projected, USA1971IAM.female.projected,
     file = here::here("data", "USA1971IAM.RData")
)



##############################################################################h#
### 1983 Table "a" (individual) and GAM (group annuities), period tables    ####
##############################################################################h#

USA1983a.data = read_excel(
  US.annuities.file, sheet = "1983a - GAM",
  col_names = c("age","qx", "qy", "qxG", "qyG"),
  skip = 4)

USA1983a.male = mortalityTable.period(
  name = "USA 1983 Table a, male",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qx,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 table a", sex = "m", collar = "Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)

USA1983a.female = mortalityTable.period(
  name = "USA 1983 Table a, female",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qy,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 table a", sex = "f", collar = "Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)


USA1983GAM.male = mortalityTable.period(
  name = "USA 1983 GAM, male",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qxG,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 GAM", sex = "m", collar = "group Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)

USA1983GAM.female = mortalityTable.period(
  name = "USA 1983 GAM, female",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qyG,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 GAM", sex = "f", collar = "group Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)

USA1983a = array(
  data = c(
    USA1983a.male, USA1983a.female
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

USA1983GAM = array(
  data = c(
    USA1983GAM.male, USA1983GAM.female
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

save(USA1983a, USA1983a.male, USA1983a.female,
     file = here::here("data", "USA1983a.RData")
)
save(USA1983GAM, USA1983GAM.male, USA1983GAM.female,
     file = here::here("data", "USA1983GAM.RData")
)




##############################################################################h#
### 1994 GAR/GAM group annuity tables, with improvement factors AA_x        ####
##############################################################################h#

USA1994GAM.data = read_excel(
  US.annuities.file, sheet = "1994 GAR",
  col_names = c("age","qx", "AAx", "qy", "AAy", "qxBasic", "qyBasic"),
  skip = 4)

USA1994GAM.male.basic = mortalityTable.period(
  name = "USA 1994 GAM basic (unloaded), male",
  ages = USA1994GAM.data$age,
  deathProbs = USA1994GAM.data$qxBasic,
  data = list(
    dim = list(table = "1994 GAM", sex = "m", collar = "group Mortality", type = "Rententafel", data = "unloaded", year = 1994)
  )
)

USA1994GAM.female.basic = mortalityTable.period(
  name = "USA 1994 GAM basic (unloaded), female",
  ages = USA1994GAM.data$age,
  deathProbs = USA1994GAM.data$qyBasic,
  data = list(
    dim = list(table = "1994 GAM", sex = "f", collar = "group Mortality", type = "Rententafel", data = "unloaded", year = 1994)
  )
)


USA1994GAR.male = mortalityTable.improvementFactors(
  name = "USA 1994 GAR, male",
  ages = USA1994GAM.data$age,
  deathProbs = USA1994GAM.data$qx,
  improvement = USA1994GAM.data$AAx,
  data = list(
    dim = list(table = "1994 GAR", sex = "m", collar = "group Reserving", type = "Rententafel", data = "loaded", year = 1994)
  )
)

USA1994GAR.female = mortalityTable.improvementFactors(
  name = "USA 1994 GAR, female",
  ages = USA1994GAM.data$age,
  deathProbs = USA1994GAM.data$qy,
  improvement = USA1994GAM.data$AAy,
  data = list(
    dim = list(table = "1994 GAR", sex = "f", collar = "group Reserving", type = "Rententafel", data = "loaded", year = 1994)
  )
)


USA1994GAM = array(
  data = c(
    USA1994GAM.male.basic, USA1994GAM.female.basic
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

USA1994GAR = array(
  data = c(
    USA1994GAR.male, USA1994GAR.female
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

save(USA1994GAM, USA1994GAM.male.basic, USA1994GAM.female.basic,
     file = here::here("data", "USA1994GAM.RData")
)
save(USA1994GAR, USA1994GAR.male, USA1994GAR.female,
     file = here::here("data", "USA1994GAR.RData")
)





#################################################################################h#
### Annuity 2000 Basic (unloaded) and Mortality (loaded) Tables, PERIOD tables ####
#################################################################################h#

USAAnnuity2000.data = read_excel(
  US.annuities.file, sheet = "Annuity 2000",
  col_names = c("age","qxBasic", "qyBasic", "qx", "qy"),
  skip = 5)

USAAnnuity2000.basic.male = mortalityTable.period(
  name = "USA Annuity 2000 basic, male",
  ages = USAAnnuity2000.data$age,
  deathProbs = USAAnnuity2000.data$qxBasic,
  data = list(
    dim = list(table = "Annuity 2000 basic", sex = "m", collar = "Basic", type = "Rententafel", data = "unloaded", year = 2000)
  )
)

USAAnnuity2000.basic.female = mortalityTable.period(
  name = "USA Annuity 2000 basic, female",
  ages = USAAnnuity2000.data$age,
  deathProbs = USAAnnuity2000.data$qyBasic,
  data = list(
    dim = list(table = "Annuity 2000 basic", sex = "f", collar = "Basic", type = "Rententafel", data = "unloaded", year = 2000)
  )
)


USAAnnuity2000.male = mortalityTable.period(
  name = "USA Annuity 2000 mortality, male",
  ages = USAAnnuity2000.data$age,
  deathProbs = USAAnnuity2000.data$qx,
  data = list(
    dim = list(table = "Annuity 2000", sex = "m", collar = "Mortality", type = "Rententafel", data = "loaded", year = 2000)
  )
)

USAAnnuity2000.female = mortalityTable.period(
  name = "USA Annuity 2000 mortality, female",
  ages = USAAnnuity2000.data$age,
  deathProbs = USAAnnuity2000.data$qy,
  data = list(
    dim = list(table = "Annuity 2000", sex = "f", collar = "Mortality", type = "Rententafel", data = "loaded", year = 2000)
  )
)


USAAnnuity2000 = array(
  data = c(
    USAAnnuity2000.basic.male, USAAnnuity2000.basic.female,
    USAAnnuity2000.male, USAAnnuity2000.female
  ),
  dim = c(2, 2),
  dimnames = list(Sex = c("m", "f"), typ = c("loaded", "basic"))
)

save(USAAnnuity2000,
    USAAnnuity2000.basic.male, USAAnnuity2000.basic.female,
    USAAnnuity2000.male, USAAnnuity2000.female,
    file = here::here("data", "USAAnnuity2000.RData")
)




