#' @import MortalityTables
NULL

stopifnot(require(methods), require(utils), require(MortalityTables), require(readxl)) # MortalityTable classes; new; Excel reader


############################################################################### #
# Pension Table AVÖ 2018-P                                                   ----
############################################################################### #

if (is.null(getOption("MortalityTables.EttlPagler"))) {
    message("The pension table EttlPagler requires the Excel file 'Austria_Pensions_EttlPagler.xlsx'. Please set its path with options(\"MortalityTables.EttlPagler\" = \"/path/to/Austria_Pensions_EttlPagler.xlsx\").")
} else {

###############################################################################
# Ettl/Pagler Male
###############################################################################

EttlPagler.data.M = read_excel(
    getOption("MortalityTables.EttlPagler"),
    skip = 5,
    col_names = c("age", "qaax", "ix", "qix", "qgx", "qpx", "qwy", "hx", "yx", "x1")
);
EttlPaglerAges = EttlPagler.data.M[["age"]];

EttlPagler.male = pensionTable(
    name = "Ettl/Pagler 1989, Männer",
    baseYear = 1989,
    qx    = mortalityTable.period(
        name = "Ettl/Pagler, qx",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["qaax"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    ix    = mortalityTable.period(
        name = "Ettl/Pagler, ix",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["ix"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Invalidisierung")
        )
    ),
    qgx   = mortalityTable.period(
        name = "Ettl/Pagler, qgx",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["qgx"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    qix   = mortalityTable.period(
        name = "Ettl/Pagler, qix",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["qix"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    rx    = mortalityTable.zeroes(name = "No reactivation", ages = EttlPaglerAges),
    apx   = mortalityTable.once(transitionAge = 65, name = "Pensionsalter 65", ages = EttlPaglerAges),
    qpx = mortalityTable.period(
        name = "Ettl/Pagler, qpx",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["qpx"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    hx    = mortalityTable.period(
        name = "Ettl/Pagler, hx",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["hx"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Partnerwahrscheinlichkeit im Tod")
        )
    ),
    qwy   = mortalityTable.period(
        name = "Ettl/Pagler, qwy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["qwy"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    yx    = mortalityTable.period(
        name = "Ettl/Pagler, y(x)",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.M[["yx"]],
        data = list(
            dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Mittl. Hinterbliebenenalter")
        )
    ),
    invalids.retire = TRUE,
    data = list(
        Geschlecht = "Männer",
        Bestand = "Angestellte",
        Invalidisierung = "Invaliditätspension",
        dim = list(sex = "m", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989")
    )
)

###############################################################################
# Ettl/Pagler Female
###############################################################################

EttlPagler.data.F = read_excel(
    getOption("MortalityTables.EttlPagler"),
    sheet = 2,
    skip = 5,
    col_names = c("age", "qaay", "iy", "qiy", "qgy", "qpy", "qwx", "hy", "xy", "y1")
);
EttlPaglerAges = EttlPagler.data.F[["age"]];

EttlPagler.female = pensionTable(
    name = "Ettl/Pagler 1989, Frauen",
    baseYear = 1989,
    qx    = mortalityTable.period(
        name = "Ettl/Pagler, qy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["qaay"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    ix    = mortalityTable.period(
        name = "Ettl/Pagler, iy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["iy"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Invalidisierung")
        )
    ),
    qgx   = mortalityTable.period(
        name = "Ettl/Pagler, qgy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["qgy"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    qix   = mortalityTable.period(
        name = "Ettl/Pagler, qiy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["qiy"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    rx    = mortalityTable.zeroes(name = "No reactivation", ages = EttlPaglerAges),
    apx   = mortalityTable.once(transitionAge = 65, name = "Pensionsalter 60", ages = EttlPaglerAges),
    qpx = mortalityTable.period(
        name = "Ettl/Pagler, qpy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["qpy"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    hx    = mortalityTable.period(
        name = "Ettl/Pagler, hy",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["hy"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Partnerwahrscheinlichkeit im Tod")
        )
    ),
    qwy   = mortalityTable.period(
        name = "Ettl/Pagler, qwx",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["qwx"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    yx    = mortalityTable.period(
        name = "Ettl/Pagler, x(y)",
        ages = EttlPaglerAges,
        deathProbs = EttlPagler.data.F[["xy"]],
        data = list(
            dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989", risk = "Tod")
        )
    ),
    invalids.retire = TRUE,
    data = list(
        Geschlecht = "Männer",
        Bestand = "Angestellte",
        Invalidisierung = "Invaliditätspension",
        dim = list(sex = "w", collar = "Gesamtbestand", table = "Ettl/Pagler 1989", type = "Pensionstafel Österreich", data = "official", year = "Ettl/Pagler 1989")
    )
)

EttlPagler = c(m = EttlPagler.male, w = EttlPagler.female)



rm(EttlPagler.data.F, EttlPagler.data.M, EttlPaglerAges)

}
