#############################################################################m#
#  Skript to generate Austrian endowment mortality table objects           ####
#############################################################################m#
library(MortalityTables)
library(here)
library(readxl)



###############################################################################
### ADSt 1924/26 Männer, 2 verbundene Leben
###############################################################################

ADSt2426.2Lives.data = read_excel(here("data-raw", "AT", "Endowments", "ADSt2426_2Lives.xlsx"), sheet = 2, skip = 1)

ADSt2426.2Lives = mortalityTable.period(
  name       = "ADSt 1924/26 Männer, 2 Leben",
  ages       = ADSt2426.2Lives.data$xx,
  deathProbs = ADSt2426.2Lives.data$qxx,
  data = list(
    dim = list(sex = "m", collar = "2-Leben", type = "Sterbetafel Deutschland", data = "verbundene Leben", year = "1924/26")
  )
)

rm(ADSt2426.2Lives.data)
save(ADSt2426.2Lives, file = here::here("data", "ADSt2426.2Lives.RData"))
