% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseProbabilities.R
\name{baseProbabilities}
\alias{baseProbabilities}
\alias{baseProbabilities,mortalityTable.period-method}
\alias{baseProbabilities,mortalityTable.mixed-method}
\title{Return the base death probabilities of the life table (with a possible
selection effect applied, but without further processing like modifications,
margins or trend extrapolation)}
\usage{
baseProbabilities(object, ..., selectionAge = NULL)

\S4method{baseProbabilities}{mortalityTable.period}(object, ..., selectionAge = -Inf)

\S4method{baseProbabilities}{mortalityTable.mixed}(object, ..., selectionAge = NULL)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{...}{Other parameters (currently unused)}

\item{selectionAge}{Age when selection starts (for tables with the \code{deathProbs} slot being a matrix rather than a single vector and for tables with \code{selectionFactors set})}
}
\description{
Return the base death probabilities of the life table (with a possible
selection effect applied, but without further processing like modifications,
margins or trend extrapolation)
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable.period}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)

\item \code{mortalityTable.mixed}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)
}}

\examples{
baseProbabilities(DAV2004R.male.selekt)
baseProbabilities(DAV2004R.male.selekt, selectionAge = 60)
baseProbabilities(DAV2004R.male.selekt, selectionAge = 65)

}
