% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMortalityTableComparisons.R
\name{plotMortalityTableComparisons}
\alias{plotMortalityTableComparisons}
\title{Plot multiple mortality tables (life tables) in one plot, relative to a given reference table}
\usage{
plotMortalityTableComparisons(
  data,
  ...,
  aes = NULL,
  ages = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  title = "",
  legend.position = c(0.9, 0.1),
  legend.justification = c(1, 0),
  legend.title = "Sterbetafel",
  legend.key.width = unit(25, "mm"),
  reference = NULL
)
}
\arguments{
\item{data}{First life table to be plotted. Either a \code{data.frame} generated by \code{makeQxDataFrame} or a \code{mortalityTable} object}

\item{...}{Additional life tables to be plotted (if \code{data} is a \code{mortalityTable} object)}

\item{aes}{Optional aesthetics to append or override the default. The default aesthetics will always be applied first and provide defaults for x, y and color. This argument can be used to override the defaults or append other aesthetics.}

\item{ages}{Plot only the given ages}

\item{xlim}{X-axis limitatation (as a two-element vector)}

\item{ylim}{Y-axis limitatation (as a two-element vector)}

\item{xlab}{X-axis label (default: "Alter")}

\item{ylab}{Y-axis label (default: "Sterbewahrscheinlichkeit q_x relativ zu ....")}

\item{title}{The plot title}

\item{legend.position}{The position of the legend (default is \code{c(0.9,0.1)})}

\item{legend.justification}{The justification of the legend (default is \code{c(1,)})}

\item{legend.title}{Title of the legend (\code{NULL} to hide)}

\item{legend.key.width}{The keywith of the lines in the  legend (default is \code{unit(25,"mm")})}

\item{reference}{The reference table that determines the 100\% values. If not given, the first argument of \code{data} is used as reference table.}
}
\description{
\code{plotMortalityTableComparisons} prints multiple life tables (objects of child classes of \code{mortalityTable}) in one plot and scales each by the given reference table, so that the relative mortality can be easily seen. A legend is added showing the names of the tables.
}
\examples{
# Load the Austrian census data
mortalityTables.load("Austria_Census")

# Compare some census tables with the mortality of 2011 Austrian males
# plot with the reference argument is the same as calling plotMortalityTableComparisons
plot(mort.AT.census.1869.male, mort.AT.census.1869.female,
     mort.AT.census.1971.male, mort.AT.census.1971.female,
     mort.AT.census.2011.male, mort.AT.census.2011.female,
     title = "Austrian Census tables, relative to 1971 males",
     reference = mort.AT.census.1971.male)
plotMortalityTableComparisons(mort.AT.census.1869.male, mort.AT.census.1869.female,
     mort.AT.census.1971.male, mort.AT.census.1971.female,
     mort.AT.census.2011.male, mort.AT.census.2011.female,
     title = "Austrian Census tables, relative to 1971 males",
     reference = mort.AT.census.1971.male)

}
