% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.setSlot}
\alias{mT.setSlot}
\alias{mT.setSlot,mortalityTable-method}
\alias{mT.setSlot,array-method}
\alias{mT.setSlot,list-method}
\alias{mT.setSlot,pensionTable-method}
\alias{mT.setSlot,NULL-method}
\title{Set a certain slot of the mortality tables (or of each element of the list of tables)}
\usage{
mT.setSlot(object, slot, value = NULL)

\S4method{mT.setSlot}{mortalityTable}(object, slot, value = NULL)

\S4method{mT.setSlot}{array}(object, slot, value = NULL)

\S4method{mT.setSlot}{list}(object, slot, value = NULL)

\S4method{mT.setSlot}{pensionTable}(object, slot, value = NULL)

\S4method{mT.setSlot}{`NULL`}(object, slot, value = NULL)
}
\arguments{
\item{object}{The mortalityTable object to be modified (or a list / array of mortalityTable object)}

\item{slot}{the desired slot to set}

\item{value}{the value for the slot}
}
\description{
The function mt.setSlot adds the given slot to all mortalityTable objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Set a slot for the given mortalityTable

\item \code{array}: Set a slot for the mortalityTables stored in an array

\item \code{list}: Set a slot for the given mortalityTables stored in a list

\item \code{pensionTable}: Set a slot for all components of a pensionTable

\item \code{NULL}: Empty dummy function that simply returns NULL
}}

\examples{
mortalityTables.load("Austria_Census")
# Add 10-year selection factors to the population mortality
mort.AT.census.2011.male.select = mT.setSlot(mort.AT.census.2011.male, "selectionFactors", 1:10/10)

}
