% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.getDimInfo}
\alias{mT.getDimInfo}
\title{Retrieve additional information (year, description, type of risk, sex, etc.) from the mortality table or list of tables.}
\usage{
mT.getDimInfo(tbl, name)
}
\arguments{
\item{tbl}{The \code{mortalityTable} object from which to extract dimensional information}

\item{name}{The name of the dimensional information (as string) to extract}
}
\description{
A mortalityTable can store additional information to be used e.g. as additional
dimensions in ggplot calls. Typically, these information include sex, base
population, observation year, type of data (raw, smoothed), country, type of
risk, etc. These additional dimensions are stored in the \code{tbl@data} list
and will be used by plotMortalityTables and similar functions.
}
\examples{
mortalityTables.load("Austria_Census")
mortalityTables.load("Austria_Annuities")
mT.getDimInfo(mort.AT.census, "table")
mT.getDimInfo(mort.AT.census, "sex")
}
