% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCohortTable.R
\name{getCohortTable}
\alias{getCohortTable}
\alias{getCohortTable,mortalityTable-method}
\alias{getCohortTable,array-method}
\alias{getCohortTable,list-method}
\alias{getCohortTable,NULL-method}
\title{Return the cohort life table as a \code{mortalityTable.period} object}
\usage{
getCohortTable(object, YOB, ...)

\S4method{getCohortTable}{mortalityTable}(object, YOB, ...)

\S4method{getCohortTable}{array}(object, YOB, ...)

\S4method{getCohortTable}{list}(object, YOB, ...)

\S4method{getCohortTable}{`NULL`}(object, YOB, ...)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{YOB}{The birth year for which the life table should be calculated}

\item{...}{Other parameters (currently unused)}
}
\description{
Return the cohort life table as a \code{mortalityTable.period} object
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Return the cohort life table as a
\code{mortalityTable.period} object

\item \code{array}: Return the cohort life table as a
\code{mortalityTable.period} object from the mortalityTable objects stored in the array

\item \code{list}: Return the cohort life table as a
\code{mortalityTable.period} object from the mortalityTable objects stored in the list

\item \code{NULL}: Empty dummy function to handle unassigned variables
}}

\examples{
mortalityTables.load("Austria_Annuities")
tb75 = getCohortTable(AVOe2005R.male, YOB = 1975)
# The tb75 is a fixed table with no trend any more
plot(AVOe2005R.male, tb75, Period = 2017)

}
