#' @import MortalityTables
NULL

stopifnot(require(methods), require(utils), require(MortalityTables), require(readxl)) # MortalityTable classes; new; Excel reader

############################################################################### #
# Pension Table AVÖ 1999P                                                   ----
############################################################################### #

if (is.null(getOption("MortalityTables.AVOe1999P"))) {
    message("The pension table AVÖ 1999P requires the Excel file 'Austria_Pensions_AVOe1999P.xlsx'. Please set its path with options(\"MortalityTables.AVOe1999P\" = \"/path/to/Austria_Pensions_AVOe1999P.xlsx\").")
} else {



AVOe1999P.generate = function(tab, name="P", collar = "Angestellte") {
    table99 = function(name, data, agevar = "x", probvar, trendvar = NULL, dim = list(), ..., baseyear = 1982) {
        if (is.null(trendvar)) {
            mortalityTable.period(
                name = name, ages = data[[agevar]], baseYear = baseyear,
                deathProbs = data[[probvar]], data = list(dim = dim))
        } else {
            mortalityTable.trendProjection(
                name = name, ages = data[[agevar]], baseYear = baseyear,
                deathProbs = data[[probvar]], trend = data[[trendvar]],
                data = list(dim = dim))
        }
    }
    name99p = function(name, desc) {
        paste("AVÖ 1999-", name, ", ", desc, sep = "")
    }

    data = read_excel(
        getOption("MortalityTables.AVOe1999P"), sheet = tab,
        skip = 4,
        col_names = c(
        "x",
        "qaax", "qix", "qpx", "qgx", "qwy", "ix", "hx", "yx",
        "SPACER1",
        "qaay", "qiy", "qpy", "qgy", "qwx", "iy", "hy", "xy",
        "SPACER2", "lambdax", "lambday")
    )

    male = pensionTable(
        name = name99p(name, "Männer"),
        baseYear = 1982,
        qx =  table99(name99p(name, "qax, active males"), data, "x", "qaax", "lambdax",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        ix =  table99(name99p(name, "ix, probability of invalidity"), data, "x", "ix",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Invalidisierung")),
        qgx = table99(name99p(name, "qgx, total males"), data, "x", "qgx", "lambdax",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        qix = table99(name99p(name, "qix, disabled males"), data, "x", "qix", "lambdax",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        rx =  mortalityTable.zeroes(name = "No reactivation", ages = data$x),
        apx = mortalityTable.once(transitionAge = 65 - 1, name = "Pensionsalter 65", ages = data$x),
        qpx = table99(name99p(name, "qpx, retired males"), data, "x", "qpx", "lambdax",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        hx =  table99(name99p(name, "hx, marriage probability"), data, "x", "hx",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Partnerwahrscheinlichkeit im Tod")),
        qwy = table99(name99p(name, "qwy, widows"), data, "x", "qwy", "lambday",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        yx =  table99(name99p(name, "y(x), age of widow"), data, "x", "yx",
                      dim = list(sex = "m", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "mittl. Hinterbliebenenalter")),
        invalids.retire = FALSE,
        data = list(
            Geschlecht = "Männer",
            Bestand = if (endsWith(name, "Arb./Ang.")) "Mischbestand" else "Angestellte",
            Invalidisierung = "Invaliditätspension"
        )
    )

    female = pensionTable(
        name = name99p(name, "Frauen"),
        baseYear = 1982,
        qx =  table99(name99p(name, "qay, active females"), data, "x", "qaay", "lambday",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        ix =  table99(name99p(name, "ix, probability of invalidity"), data, "x", "iy",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Invalidisierung")),
        qgx = table99(name99p(name, "qgy, total females"), data, "x", "qgx", "lambday",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        qix = table99(name99p(name, "qiy, disabled females"), data, "x", "qix", "lambday",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        rx =  mortalityTable.zeroes(name = "No reactivation", ages = data$x),
        apx = mortalityTable.once(transitionAge = 60 - 1, name = "Pensionsalter 60", ages = data$x),
        qpx = table99(name99p(name, "qpy, retired females"), data, "x", "qpx", "lambday",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        hx =  table99(name99p(name, "hy, marriage probability"), data, "x", "hy",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Partnerwahrscheinlichkeit im Tod")),
        qwy = table99(name99p(name, "qwx, widowers"), data, "x", "qwx", "lambdax",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "Tod")),
        yx =  table99(name99p(name, "x(y), age of widower"), data, "x", "xy",
                      dim = list(sex = "w", collar = collar, type = "Pensionstafel Österreich", data = "official", year = "AVÖ 1999-P", risk = "mittl. Hinterbliebenenalter")),
        invalids.retire = FALSE,
        data = list(
            Geschlecht = "Frauen",
            Bestand = if (endsWith(name, "Arb./Ang.")) "Mischbestand" else "Angestellte",
            Invalidisierung = "Invaliditätspension"
        )
    )

    list(male = male, female = female)
}

############################################################################## #
# Die Tafel als Array ----
############################################################################## #

AVOe1999P = array(
    data = c(mortalityTable.NA),
    dim = c(2, 2),
    dimnames = list(Geschlecht = c("m", "w"), Bestand = c("Angestellte", "Mischbestand"))
)
AVOe1999PK = array(
    data = c(mortalityTable.NA),
    dim = c(2, 2),
    dimnames = list(Geschlecht = c("m", "w"), Bestand = c("Angestellte", "Mischbestand"))
)
AVOe1999P[, "Angestellte"] = AVOe1999P.generate(tab = "Angestellte", "P", collar = "Angestellte")
AVOe1999P[, "Mischbestand"] = AVOe1999P.generate(tab = "Arbeiter+Angestellte", "P Arb./Ang.", collar = "Mischbestand")
AVOe1999PK[, "Angestellte"] = AVOe1999P.generate(tab = "Angestellte PK", "PK", collar = "Angestellte")
AVOe1999PK[, "Mischbestand"] = AVOe1999P.generate(tab = "Arbeiter+Angestellte PK", "P< Arb./Ang.", collar = "Mischbestand")


AVOe1999P.male = AVOe1999P[["m", "Angestellte"]]
AVOe1999P.female = AVOe1999P[["w", "Angestellte"]]
AVOe1999P.male.Misch = AVOe1999P[["m", "Mischbestand"]]
AVOe1999P.female.Misch = AVOe1999P[["w", "Mischbestand"]]

rm(AVOe1999P.generate)

}
