################################################################################m#
#  Skript to generate US Basic (select and ultimate) valuation table objects  ####
################################################################################m#
library(MortalityTables)
library(here)
library(readxl)
library(dplyr)
# library(purrr)

US.annuities.file = here::here("data-raw", "US", "Annuities", "USA_Annuities.xlsx")



###############################################################################
### 1971 IAM individual annuity table; with optional projection scale B_x
###############################################################################

USA1971IAM.data = read_excel(
  US.annuities.file, sheet = "1971 IAM",
  col_names = c("age","qx", "qy", "B"),
  skip = 4)

USA1971IAM.male = mortalityTable.period(
  name = "USA 1971 IAM, male",
  ages = USA1971IAM.data$age,
  deathProbs = USA1971IAM.data$qx,
  data = list(
    dim = list(table = "1971 IAM", sex = "m", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM.female = mortalityTable.period(
  name = "USA 1971 IAM, female",
  ages = USA1971IAM.data$age,
  deathProbs = USA1971IAM.data$qy,
  data = list(
    dim = list(table = "1971 IAM", sex = "w", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM.male.projected = mortalityTable.improvementFactors(
  name = "USA 1971 IAM, male, projected",
  ages = USA1971IAM.data$age,
  baseYear = 1971,
  deathProbs = USA1971IAM.data$qx,
  improvement = USA1971IAM.data$B,
  data = list(
    dim = list(table = "1971 IAM projected", sex = "m", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM.female.projected = mortalityTable.improvementFactors(
  name = "USA 1971 IAM, female, projected",
  ages = USA1971IAM.data$age,
  baseYear = 1971,
  deathProbs = USA1971IAM.data$qy,
  improvement = USA1971IAM.data$B,
  data = list(
    dim = list(table = "1971 IAM projected", sex = "w", collar = "Mortality", type = "Rententafel", data = "unloaded", year = 1971)
  )
)

USA1971IAM = array(
  data = c(
    USA1971IAM.male, USA1971IAM.female, USA1971IAM.male.projected, USA1971IAM.female.projected
  ),
  dim = c(2, 2),
  dimnames = list(Sex = c("m", "f"), type = c("Period", "Generational"))
)

save(USA1971IAM, USA1971IAM.male, USA1971IAM.female, USA1971IAM.male.projected, USA1971IAM.female.projected,
     file = here::here("data", "US1971IAM.RData")
)



###############################################################################
### 1983 Table "a" (individual) and GAM (group annuities), period tables
###############################################################################

USA1983a.data = read_excel(
  US.annuities.file, sheet = "1983a - GAM",
  col_names = c("age","qx", "qy", "qxG", "qyG"),
  skip = 4)

USA1983a.male = mortalityTable.period(
  name = "USA 1983 Table a, male",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qx,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 table a", sex = "m", collar = "Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)

USA1983a.female = mortalityTable.period(
  name = "USA 1983 Table a, female",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qy,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 table a", sex = "w", collar = "Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)


USA1983GAM.male = mortalityTable.period(
  name = "USA 1983 GAM, male",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qxG,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 GAM", sex = "m", collar = "group Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)

USA1983GAM.female = mortalityTable.period(
  name = "USA 1983 GAM, female",
  ages = USA1983a.data$age,
  deathProbs = USA1983a.data$qyG,
  baseYear = 1983,
  data = list(
    dim = list(table = "1983 GAM", sex = "w", collar = "group Mortality", type = "Rententafel", data = "loaded", year = 1983)
  )
)

USA1983a = array(
  data = c(
    USA1983a.male, USA1983a.female
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

USA1983GAM = array(
  data = c(
    USA1983GAM.male, USA1983GAM.female
  ),
  dim = c(2),
  dimnames = list(Sex = c("m", "f"))
)

save(USA1983a, USA1983a.male, USA1983a.female,
     file = here::here("data", "USA1983a.RData")
)
save(USA1983GAM, USA1983GAM.male, USA1983GAM.female,
     file = here::here("data", "USA1983GAM.RData")
)




