% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMortalityTables.R
\name{plotMortalityTables}
\alias{plotMortalityTables}
\title{Plot multiple mortality tables (life tables) in one plot}
\usage{
plotMortalityTables(data, ..., xlim = NULL, ylim = NULL, xlab = NULL,
  ylab = NULL, title = "", legend.position = c(0.9, 0.1),
  legend.key.width = unit(25, "mm"))
}
\arguments{
\item{data}{First life table to be plotted. Either a \code{data.frame} generated by \code{makeQxDataFrame} or a \code{mortalityTable} object}

\item{...}{Additional life tables to be plotted (if \code{data} is a \code{mortalityTable} object)}

\item{xlim}{X-axis limitatation (as a two-element vector)}

\item{ylim}{Y-axis limitatation (as a two-element vector)}

\item{xlab}{X-axis label (default: "Alter")}

\item{ylab}{Y-axis label (default: "Sterbewahrscheinlichkeit q_x relativ zu ....")}

\item{title}{The plot title}

\item{legend.position}{The position of the legend (default is \code{c(0.9,0.1)})}

\item{legend.key.width}{The keywith of the lines in the  legend (default is \code{unit(25,"mm")})}
}
\description{
\code{plotMortalityTables} prints multiple life tables (objects of child classes of \code{mortalityTable}) in one log-linear plot, with a legend showing the names of the tables.
}
