% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMortalityTableComparisons.R
\name{plotMortalityTableComparisons}
\alias{plotMortalityTableComparisons}
\title{Plot multiple mortality tables (life tables) in one plot, relative to a given reference table}
\usage{
plotMortalityTableComparisons(data, ..., xlim = NULL, ylim = NULL,
  xlab = NULL, ylab = NULL, title = "", legend.position = c(0.9, 0.1),
  legend.key.width = unit(25, "mm"), reference = NULL)
}
\arguments{
\item{data}{First life table to be plotted. Either a \code{data.frame} generated by \code{makeQxDataFrame} or a \code{mortalityTable} object}

\item{...}{Additional life tables to be plotted (if \code{data} is a \code{mortalityTable} object)}

\item{xlim}{X-axis limitatation (as a two-element vector)}

\item{ylim}{Y-axis limitatation (as a two-element vector)}

\item{xlab}{X-axis label (default: "Alter")}

\item{ylab}{Y-axis label (default: "Sterbewahrscheinlichkeit q_x relativ zu ....")}

\item{title}{The plot title}

\item{legend.position}{The position of the legend (default is \code{c(0.9,0.1)})}

\item{legend.key.width}{The keywith of the lines in the  legend (default is \code{unit(25,"mm")})}

\item{reference}{The reference table that determines the 100\% values. If not given, the first argument of \code{data} is used as reference table.}
}
\description{
\code{plotMortalityTableComparisons} prints multiple life tables (objects of child classes of \code{mortalityTable}) in one plot and scales each by the given reference table, so that the relative mortality can be easily seen. A legend is added showing the names of the tables.
}
