% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTable.trendProjection.R
\docType{class}
\name{mortalityTable.trendProjection-class}
\alias{mortalityTable.trendProjection-class}
\alias{mortalityTable.trendProjection}
\title{Class mortalityTable.trendProjection - Cohort mortality table with age-specific trend}
\description{
A cohort mortality table, obtained by a trend projection from a given base table
(PODs for a given observation year). Typically, the trend is obtained by
the Lee-Carter method or some other trend estimation.
The dampingFunction can be used to modify the cumulative years (e.g. G(tau+x)
instead of tau+x)
If trend2 is given, the G(tau+x) gives the weight of the first trend,
1-G(tau+x) the weight of the second trend
}
\section{Slots}{

\describe{
\item{\code{baseYear}}{The base year of the trend projection (\code{baseTable}
describes the death probabilities in this year)}

\item{\code{trend}}{The yearly improvements of the log-death probabilities (per age)}

\item{\code{dampingFunction}}{A possible damping of the trend. This is a function
\code{damping(delta_years)} that gets a vector of years
from the baseYear and should return the dampened values.}

\item{\code{trend2}}{The alternate trend. If given, the damping function
interpolates between \code{trend} and \code{trend2}, otherwise
the dumping function simply modifies the coefficients of
\code{trend}.}
}}

