% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityComparisonTable.R
\name{mortalityComparisonTable}
\alias{mortalityComparisonTable}
\title{Calculate relative mortalities for age bands and birth years}
\usage{
mortalityComparisonTable(table1, table2, years, ages, binsize = 5, ...)
}
\arguments{
\item{table1, table2}{The \code{\link{mortalityTable}} objects to compare (mortalities of \code{table1} relative to \code{table2})}

\item{years}{Vector of birth years to include in the comparisons.}

\item{ages}{Vector of ages to include in the comparisons}

\item{binsize}{How many ages to combine into one age band}

\item{...}{Other parameters (currently unused)}
}
\description{
Calculate relative mortalities for age bands and birth years
}
\examples{
mortalityTables.load("Austria_Annuities")
# Compare mortality of Austrian male and female annuitants born 1930 to 2030
mortalityComparisonTable(
    AVOe2005R.male, AVOe2005R.female,
    years = seq(1930, 2030, by = 10),
    ages = 0:119)

# Compare the two Austrian male annuity tables AVOe 2005-R and AVOe 1996-R,
# combining ages 10-19, 20-29, etc.
mortalityComparisonTable(
    AVOe2005R.male, AVOe1996R.male,
    years = seq(1930, 2030, by = 10),
    ages = 0:109, binsize=10)


}
