% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deathProbabilities.R,
%   R/mortalityTable.jointLives.R
\docType{methods}
\name{deathProbabilities}
\alias{deathProbabilities}
\alias{deathProbabilities,mortalityTable.period-method}
\alias{deathProbabilities,mortalityTable.ageShift-method}
\alias{deathProbabilities,mortalityTable.trendProjection-method}
\alias{deathProbabilities,mortalityTable.improvementFactors-method}
\alias{deathProbabilities,mortalityTable.mixed-method}
\alias{deathProbabilities,mortalityTable.jointLives-method}
\title{Return the (cohort) death probabilities of the life table given the birth year (if needed)}
\usage{
deathProbabilities(object, ..., YOB = 1975)

\S4method{deathProbabilities}{mortalityTable.period}(object, ..., YOB = 1975)

\S4method{deathProbabilities}{mortalityTable.ageShift}(object, ...,
  YOB = 1975)

\S4method{deathProbabilities}{mortalityTable.trendProjection}(object, ...,
  YOB = 1975)

\S4method{deathProbabilities}{mortalityTable.improvementFactors}(object, ...,
  YOB = 1975)

\S4method{deathProbabilities}{mortalityTable.mixed}(object, ..., YOB = 1975)

\S4method{deathProbabilities}{mortalityTable.jointLives}(object, ...,
  ageDifferences = c(), YOB = 1975)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{...}{Other parameters (currently unused)}

\item{YOB}{The birth year for which the death probabilities should be calculated}

\item{ageDifferences}{A vector of age differences of all joint lives.}
}
\description{
Return the (cohort) death probabilities of the life table given the birth year (if needed)
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable.period}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)

\item \code{mortalityTable.ageShift}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)

\item \code{mortalityTable.trendProjection}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)

\item \code{mortalityTable.improvementFactors}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)

\item \code{mortalityTable.mixed}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)

\item \code{mortalityTable.jointLives}: Return the (cohort) death probabilities of the
life table given the birth year (if needed)
}}

\examples{
mortalityTables.load("Austria_Annuities")
deathProbabilities(AVOe2005R.male, YOB = 1975)
deathProbabilities(AVOe2005R.male, YOB = 2017)

mortalityTables.load("Germany_Census")
table.JL = mortalityTable.jointLives(
    name = "ADSt 24/26 auf verbundene Leben",
    table = mort.DE.census.1924.26.male
)
deathProbabilities(table.JL, YOB = 1977, ageDifferences = c(1, 5, -5, 16))
deathProbabilities(table.JL, YOB = 1977, ageDifferences = c(0))
deathProbabilities(table.JL, YOB = 1977, ageDifferences = c(1, 5, 16))

}
